﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using DataAccess;
using Newtonsoft;
using Newtonsoft.Json;
using System;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml;
using System.Xml.Linq;
using Ext.Net;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "REPSPAT")]

public partial class reports_pat : System.Web.UI.Page
{
    public BaseMaster BaseMstr { set; get; }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///
    /// </summary>
    public void OnTreeSelect(string str)
    {
        btnMeasureTrend.Enable();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7492 On note select, show the note
    /// </summary>
    public object OnNoteSelect(int nRowIndex, int nCellIndex, string strJ)
    {
        string strJSON = strJ;
        if (strJSON.Length > 2)
        {
            if (strJSON.Substring(0, 1) == "[")
            {
                strJSON = strJSON.Substring(1);
            }

            if (strJSON.Substring(strJSON.Length - 1, 1) == "]")
            {
                strJSON = strJSON.Substring(0, strJSON.Length - 1);
            }
        }

        string strNote = String.Empty;

        string strPatientID = CDataUtils2.GetJsonRecordValue("PATIENT_ID", strJSON);

        string strNote1 = CDataUtils2.GetJsonRecordValue("NOTE_1", strJSON);
        string strNote2 = CDataUtils2.GetJsonRecordValue("NOTE_2", strJSON);
        string strNote3 = CDataUtils2.GetJsonRecordValue("NOTE_3", strJSON);
        string strNote4 = CDataUtils2.GetJsonRecordValue("NOTE_4", strJSON);
        string strNote5 = CDataUtils2.GetJsonRecordValue("NOTE_5", strJSON);
        string strNote6 = CDataUtils2.GetJsonRecordValue("NOTE_6", strJSON);

        string strPatPWEvent1 = CDataUtils2.GetJsonRecordValue("PATPWEVENT_1", strJSON);
        string strPatPWEvent2 = CDataUtils2.GetJsonRecordValue("PATPWEVENT_2", strJSON);
        string strPatPWEvent3 = CDataUtils2.GetJsonRecordValue("PATPWEVENT_3", strJSON);
        string strPatPWEvent4 = CDataUtils2.GetJsonRecordValue("PATPWEVENT_4", strJSON);
        string strPatPWEvent5 = CDataUtils2.GetJsonRecordValue("PATPWEVENT_5", strJSON);
        string strPatPWEvent6 = CDataUtils2.GetJsonRecordValue("PATPWEVENT_6", strJSON);
        
        long lSelectedPatPWEvent = -1;
        if (nCellIndex == 0)
        {
            lSelectedPatPWEvent = CDataUtils2.ToLong(strPatPWEvent1);
        }
        else if (nCellIndex == 1)
        {
            lSelectedPatPWEvent = CDataUtils2.ToLong(strPatPWEvent2);
        }
        else if (nCellIndex == 2)
        {
            lSelectedPatPWEvent = CDataUtils2.ToLong(strPatPWEvent3);
        }
        else if (nCellIndex == 3)
        {
            lSelectedPatPWEvent = CDataUtils2.ToLong(strPatPWEvent4);
        }
        else if (nCellIndex == 4)
        {
            lSelectedPatPWEvent = CDataUtils2.ToLong(strPatPWEvent5);
        }
        else if (nCellIndex == 5)
        {
            lSelectedPatPWEvent = CDataUtils2.ToLong(strPatPWEvent6);
        }

        if (lSelectedPatPWEvent > 0)
        {
            //Get the note...
            CReportsPat rep = new CReportsPat();
            DataSet ds = rep.GetNoteTextDS(Master, strPatientID, lSelectedPatPWEvent, dfFromDate.SelectedDate, dfToDate.SelectedDate);

            if (ds != null)
            {
                foreach (DataTable dt in ds.Tables)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        //strNote = CDataUtils2.GetDSStringValue(dr, "NOTE_TEXT");
                        strNote = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(dr, "NOTE_TEXT"));
                    }
                }
            }

        }

        return new { Note = strNote };

    }
        
    /// <summary>
    /// US:7493 load the trend tree
    /// </summary>
    /// <param name="strPatID"></param>
    /// <param name="dtFromDate"></param>
    /// <param name="dtToDate"></param>
    protected void LoadTrend(string strPatID, DateTime dtFromDate, DateTime dtToDate)
    {
        CPWEvent evt = new CPWEvent();

        CReportsPat pat = new CReportsPat();
        DataSet ds = pat.GetTrendBaseDS(Master,
                                        strPatID);

        //clear the root
        if (tpnlTrend.Root != null)
        {
            if (tpnlTrend.Root.Count > 0)
            {
                tpnlTrend.Root.Clear();
            }
        }

        //add a new root
        Ext.Net.Node ndRoot;
        ndRoot = new Node() { Text = "" };
        ndRoot.Expanded = true;
        ndRoot.EmptyChildren = true;
        tpnlTrend.Root.Add(ndRoot);

        if (ds != null)
        {
            foreach (DataTable table in ds.Tables)
            {
                foreach (DataRow row in table.Rows)
                {
                    bool bGoal = false;
                    if (CDataUtils2.GetDSLongValue(row, "IS_GOAL") > 0)
                    {
                        bGoal = true;
                    }

                    if (!bGoal)
                    {
                        //new node under root
                        Ext.Net.Node nd = new Ext.Net.Node();

                        //set the text of the node
                        nd.Text = CDataUtils2.GetDSStringValue(row, "MODULE");

                        //set the severity
                        long lSevID = CDataUtils2.GetDSLongValue(row, "current_severity_id");
                        //default unk
                        nd.IconFile = "images/gray15t.png";
                        nd.Qtip = "Gray";
                        if (lSevID == 1) //mild
                        {
                            nd.IconFile = "images/green15t.png";
                            nd.Qtip = "Green";
                        }
                        if (lSevID == 2) //moderate
                        {
                            nd.IconFile = "images/yellow15t.png";
                            nd.Qtip = "Yellow";
                        }
                        if (lSevID == 3) //severe
                        {
                            nd.IconFile = "images/red15t.png";
                            nd.Qtip = "Red";
                        }

                        //set the node id
                        nd.NodeID = CDataUtils2.GetDSStringValue(row, "PW_EVENT_MODULE_ID");

                        //do not expand and dont show empty children
                        nd.Expanded = false;
                        nd.EmptyChildren = false;

                        //default to having children, will reset below as needed
                        nd.Leaf = false;

                        //add items to the tree/grid
                        ConfigItem ciPatientID = new ConfigItem("patient_id", CDataUtils2.GetDSStringValue(row, "patient_id"));
                        nd.CustomAttributes.Add(ciPatientID);

                        ConfigItem ciModuleID = new ConfigItem("mid", CDataUtils2.GetDSStringValue(row, "mid"));
                        nd.CustomAttributes.Add(ciModuleID);

                        ConfigItem ciIntakeID = new ConfigItem("intake_id", CDataUtils2.GetDSStringValue(row, "intake_id"));
                        nd.CustomAttributes.Add(ciIntakeID);

                        ConfigItem ciModule = new ConfigItem("module", CDataUtils2.GetDSStringValue(row, "module"));
                        nd.CustomAttributes.Add(ciModule);

                        ConfigItem ciCurrInterp = new ConfigItem("current_interpretation", CDataUtils2.GetDSStringValue(row, "current_interpretation"));
                        nd.CustomAttributes.Add(ciCurrInterp);

                        ConfigItem ciCurrScore = new ConfigItem("current_score", CDataUtils2.GetDSStringValue(row, "current_score"));
                        nd.CustomAttributes.Add(ciCurrScore);

                        ConfigItem ciPrevScore = new ConfigItem("prev_score", CDataUtils2.GetDSStringValue(row, "prev_score"));
                        nd.CustomAttributes.Add(ciPrevScore);

                        ConfigItem ciCurrStatus = new ConfigItem("current_status", CDataUtils2.GetDSStringValue(row, "current_status"));
                        nd.CustomAttributes.Add(ciCurrStatus);

                        ConfigItem ciReview = new ConfigItem("pw_event_module_id", CDataUtils2.GetDSStringValue(row, "pw_event_module_id"));
                        ciReview.Value = CDataUtils2.GetDSStringValue(row, "pw_event_module_id");
                        nd.CustomAttributes.Add(ciReview);

                        ConfigItem ciPatPWEventID = new ConfigItem("pat_pw_event_id", CDataUtils2.GetDSStringValue(row, "pat_pw_event_id"));
                        nd.CustomAttributes.Add(ciPatPWEventID);

                        ConfigItem ciPatPWID = new ConfigItem("pat_pw_id", CDataUtils2.GetDSStringValue(row, "pat_pw_id"));
                        nd.CustomAttributes.Add(ciPatPWID);

                        ConfigItem ciCurrStatusID = new ConfigItem("current_status_id", CDataUtils2.GetDSStringValue(row, "current_status_id"));
                        nd.CustomAttributes.Add(ciCurrStatusID);

                        ConfigItem ciCurrSeverityID = new ConfigItem("current_severity_id", CDataUtils2.GetDSStringValue(row, "current_severity_id"));
                        nd.CustomAttributes.Add(ciCurrSeverityID);

                        ConfigItem ciCurrSeverity = new ConfigItem("current_severity", CDataUtils2.GetDSStringValue(row, "current_severity"));
                        nd.CustomAttributes.Add(ciCurrSeverity);

                        ConfigItem ciEventStatus = new ConfigItem("event_status", CDataUtils2.GetDSStringValue(row, "event_status"));
                        nd.CustomAttributes.Add(ciEventStatus);

                        //get the intake id
                        long lIntakeID = CDataUtils2.GetDSLongValue(row, "intake_id");
                        long lMID = CDataUtils2.GetDSLongValue(row, "mid");

                        //get sub scores if we have an intake_id
                        if (lIntakeID > 0)
                        {
                            bool bHasChildren = false;
                            DataSet dsScores = pat.GetIntakeScoreDS(Master, strPatID, lIntakeID, lMID);
                            if (dsScores != null)
                            {
                                foreach (DataTable tableScore in dsScores.Tables)
                                {
                                    foreach (DataRow rowScore in tableScore.Rows)
                                    {
                                        //exclude total score from subs as its already shown above
                                        long lSeries = CDataUtils2.GetDSLongValue(rowScore, "series");
                                        if (lSeries > 0)
                                        {
                                            bHasChildren = true;

                                            Ext.Net.Node ndSub = new Ext.Net.Node();

                                            ndSub.Text = "";
                                            ndSub.Icon = Ext.Net.Icon.BulletBlack;

                                            //not expanded
                                            ndSub.Expanded = false;

                                            //no empty children
                                            ndSub.EmptyChildren = false;

                                            //subscale scores have no sub items so they are a leaf
                                            ndSub.Leaf = true;

                                            //add an item to the module section, in this case its the description of the score
                                            ConfigItem ciModuleSub = new ConfigItem("module", CDataUtils2.GetDSStringValue(rowScore, "description"));
                                            ndSub.CustomAttributes.Add(ciModuleSub);

                                            //sub scale interpretation
                                            ConfigItem cic1 = new ConfigItem("current_interpretation", CDataUtils2.GetDSStringValue(rowScore, "interpretation"));
                                            ndSub.CustomAttributes.Add(cic1);

                                            //sub scale score
                                            ConfigItem cic2 = new ConfigItem("current_score", CDataUtils2.GetDSStringValue(rowScore, "score"));
                                            ndSub.CustomAttributes.Add(cic2);

                                            //no prev score
                                            ConfigItem cic3 = new ConfigItem("prev_score", CDataUtils2.GetDSStringValue(rowScore, "prev_score"));
                                            ndSub.CustomAttributes.Add(cic3);

                                            //no current status for subs
                                            ConfigItem cic4 = new ConfigItem("current_status", "");
                                            ndSub.CustomAttributes.Add(cic4);

                                            ConfigItem cic5 = new ConfigItem("pw_event_module_id", "-1");
                                            ndSub.CustomAttributes.Add(cic5);

                                            ndSub.CustomAttributes.Add(ciPatientID);
                                            ndSub.CustomAttributes.Add(ciModuleID);
                                            ndSub.CustomAttributes.Add(ciIntakeID);

                                            //add the sub to the tree
                                            nd.Children.Add(ndSub);
                                        }
                                    }
                                }
                            }

                            //if the dataset is empty then we have no chidlren
                            if (CDataUtils2.IsEmpty(dsScores))
                            {
                                nd.Leaf = true;
                            }

                            if (!bHasChildren)
                            {
                                nd.Leaf = true;
                            }

                        }
                        else
                        {
                            //no sub scales to show so this is a leaf and cannot be expanded
                            nd.Leaf = true;
                        }

                        //add the outcome and scores to the root node
                        ndRoot.Children.Add(nd);

                    }//do not include GOALs in the list
                }
            }
        }

        //I had to move the tree inside of another panel
        //then all worked
        tpnlTrend.Render(tpnlTrend, RenderMode.Replace);

    }
    
    /// <summary>
    /// US:7492 Load the patients notes
    /// </summary>
    /// <param name="strPatID"></param>
    /// <param name="dtFromDate"></param>
    /// <param name="dtToDate"></param>
    protected void LoadNotes(string strPatID, DateTime dtFromDate, DateTime dtToDate)
    {
        //get list of modules that have scores in this date range
        CReportsPat rep = new CReportsPat();
        DataSet dsNotes = rep.GetNoteDatesDS(Master,
                                             strPatID,
                                             dtFromDate,
                                             dtToDate);

        //record looks like this
        //NOTE_1,NOTE_2,NOTE_3,NOTE_4,NOTE_5,NOTE_6,
        //PATPWEVENT_1,PATPWEVENT_2,PATPWEVENT_3,PATPWEVENT_4,PATPWEVENT_5,PATPWEVENT_6,
        DataSet dsNoteDates = new DataSet();
        DataTable dtblNotes = new DataTable();
        dtblNotes.Columns.Add("PATIENT_ID");
        dtblNotes.Columns.Add("NOTE_1");
        dtblNotes.Columns.Add("NOTE_2");
        dtblNotes.Columns.Add("NOTE_3");
        dtblNotes.Columns.Add("NOTE_4");
        dtblNotes.Columns.Add("NOTE_5");
        dtblNotes.Columns.Add("NOTE_6");
        dtblNotes.Columns.Add("PATPWEVENT_1");
        dtblNotes.Columns.Add("PATPWEVENT_2");
        dtblNotes.Columns.Add("PATPWEVENT_3");
        dtblNotes.Columns.Add("PATPWEVENT_4");
        dtblNotes.Columns.Add("PATPWEVENT_5");
        dtblNotes.Columns.Add("PATPWEVENT_6");

        //loop and load 
        string dt1 = "";
        string dt2 = "";
        string dt3 = "";
        string dt4 = "";
        string dt5 = "";
        string dt6 = "";

        long lPWID1 = 0;
        long lPWID2 = 0;
        long lPWID3 = 0;
        long lPWID4 = 0;
        long lPWID5 = 0;
        long lPWID6 = 0;

        foreach (DataTable dt in dsNotes.Tables)
        {
            int i = 0;
            foreach (DataRow dr in dt.Rows)
            {
                //string strPatientID = CDataUtils2.GetDSStringValue(dr, "PATIENT_ID");
                long lPatPWEventID = CDataUtils2.GetDSLongValue(dr, "PAT_PW_EVENT_ID");
                DateTime dtNoteDate = CDataUtils2.GetDSDateTimeValue(dr, "TIU_DATE_SUBMITTED");
                if (i == 0)
                {
                    dt1 = CDataUtils2.GetDateAsString(dtNoteDate);
                    lPWID1 = lPatPWEventID;
                }
                if (i == 1)
                {
                    dt2 = CDataUtils2.GetDateAsString(dtNoteDate);
                    lPWID2 = lPatPWEventID;
                }
                if (i == 2)
                {
                    dt3 = CDataUtils2.GetDateAsString(dtNoteDate);
                    lPWID3 = lPatPWEventID;
                }
                if (i == 3)
                {
                    dt4 = CDataUtils2.GetDateAsString(dtNoteDate);
                    lPWID4 = lPatPWEventID;
                }
                if (i == 4)
                {
                    dt5 = CDataUtils2.GetDateAsString(dtNoteDate);
                    lPWID5 = lPatPWEventID;
                }
                if (i == 5)
                {
                    dt6 = CDataUtils2.GetDateAsString(dtNoteDate);
                    lPWID6 = lPatPWEventID;
                }

                i++;
                if (i > 5)
                {
                    //write the record
                    dtblNotes.Rows.Add(new object[] { strPatID, dt1, dt2, dt3, dt4, dt5, dt6, lPWID1, lPWID2, lPWID3, lPWID4, lPWID5, lPWID6 });

                    //reset i and vars
                    i = 0;
                    lPWID1 = 0;
                    lPWID2 = 0;
                    lPWID3 = 0;
                    lPWID4 = 0;
                    lPWID5 = 0;
                    lPWID6 = 0;
                    dt1 = "";
                    dt2 = "";
                    dt3 = "";
                    dt4 = "";
                    dt5 = "";
                    dt6 = "";
                }
            }
        }

        //check if we have leftovers to write
        if (lPWID1 > 0)
        {
            dtblNotes.Rows.Add(new object[] { strPatID, dt1, dt2, dt3, dt4, dt5, dt6, lPWID1, lPWID2, lPWID3, lPWID4, lPWID5, lPWID6 });

            dsNoteDates.Tables.Add(dtblNotes);
        }
                
        //clear the grid
        storNotes.SetDataFromJson(CDataUtils2.GetEmptyJSON());
        
        if(!CDataUtils2.IsEmpty(dsNoteDates))
        {
            CDataConverter cdc = new CDataConverter();
            storNotes.SetDataFromJson(cdc.GetJsonDSString(dsNoteDates));
        }
    
    }

    /// <summary>
    ///US:7496 Load the scores grid with last 10 for each
    /// </summary>
    /// <param name="strPatID"></param>
    /// <param name="dtFromDate"></param>
    /// <param name="dtToDate"></param>
    protected void LoadScores(string strPatID, DateTime dtFromDate, DateTime dtToDate)
    {
        //get list of modules that have scores in this date range
        CReportsPat rep = new CReportsPat();
        DataSet dsScoreBase = rep.GetInstrumentBaseRS(Master,
                                                      strPatID,
                                                      dtFromDate,
                                                      dtToDate);

        //loop and load 10 to 1 for each row
        foreach (DataTable dt in dsScoreBase.Tables)
        {
            foreach (DataRow dr in dt.Rows)
            {
                //get module scores for this date range and loop 10 to 1
                long lMID = CDataUtils2.GetDSLongValue(dr, "MID");
                DataSet dsScores = rep.GetInstrumentScoreRS(Master,
                                                             strPatID,
                                                             lMID,
                                                             dtFromDate,
                                                             dtToDate);
                int j = 0;
                foreach (DataTable dtS in dsScores.Tables)
                {
                    foreach (DataRow drS in dtS.Rows)
                    {
                        if (j == 0)
                        {
                            dr["SCORE_10"] = CDataUtils2.GetDSDoubleValue(drS, "SCORE");
                            dr["DATE_10"] = CDataUtils2.GetDSDateTimeValue(drS, "COMPLETE_DATE");
                            dr["NAME_10"] = CDataUtils2.GetDSStringValue(drS, "NAME");
                            dr["INTERPRETATION_10"] = CDataUtils2.GetDSStringValue(drS, "INTERPRETATION");
                        }
                        if (j == 1)
                        {
                            dr["SCORE_9"] = CDataUtils2.GetDSDoubleValue(drS, "SCORE");
                            dr["DATE_9"] = CDataUtils2.GetDSDateTimeValue(drS, "COMPLETE_DATE");
                            dr["NAME_9"] = CDataUtils2.GetDSStringValue(drS, "NAME");
                            dr["INTERPRETATION_9"] = CDataUtils2.GetDSStringValue(drS, "INTERPRETATION");
                        }
                        if (j == 2)
                        {
                            dr["SCORE_8"] = CDataUtils2.GetDSDoubleValue(drS, "SCORE");
                            dr["DATE_8"] = CDataUtils2.GetDSDateTimeValue(drS, "COMPLETE_DATE");
                            dr["NAME_8"] = CDataUtils2.GetDSStringValue(drS, "NAME");
                            dr["INTERPRETATION_8"] = CDataUtils2.GetDSStringValue(drS, "INTERPRETATION");
                        }
                        if (j == 3)
                        {
                            dr["SCORE_7"] = CDataUtils2.GetDSDoubleValue(drS, "SCORE");
                            dr["DATE_7"] = CDataUtils2.GetDSDateTimeValue(drS, "COMPLETE_DATE");
                            dr["NAME_7"] = CDataUtils2.GetDSStringValue(drS, "NAME");
                            dr["INTERPRETATION_7"] = CDataUtils2.GetDSStringValue(drS, "INTERPRETATION");
                        }
                        if (j == 4)
                        {
                            dr["SCORE_6"] = CDataUtils2.GetDSDoubleValue(drS, "SCORE");
                            dr["DATE_6"] = CDataUtils2.GetDSDateTimeValue(drS, "COMPLETE_DATE");
                            dr["NAME_6"] = CDataUtils2.GetDSStringValue(drS, "NAME");
                            dr["INTERPRETATION_6"] = CDataUtils2.GetDSStringValue(drS, "INTERPRETATION");
                        }
                        if (j == 5)
                        {
                            dr["SCORE_5"] = CDataUtils2.GetDSDoubleValue(drS, "SCORE");
                            dr["DATE_5"] = CDataUtils2.GetDSDateTimeValue(drS, "COMPLETE_DATE");
                            dr["NAME_5"] = CDataUtils2.GetDSStringValue(drS, "NAME");
                            dr["INTERPRETATION_5"] = CDataUtils2.GetDSStringValue(drS, "INTERPRETATION");
                        }
                        if (j == 6)
                        {
                            dr["SCORE_4"] = CDataUtils2.GetDSDoubleValue(drS, "SCORE");
                            dr["DATE_4"] = CDataUtils2.GetDSDateTimeValue(drS, "COMPLETE_DATE");
                            dr["NAME_4"] = CDataUtils2.GetDSStringValue(drS, "NAME");
                            dr["INTERPRETATION_4"] = CDataUtils2.GetDSStringValue(drS, "INTERPRETATION");
                        }
                        if (j == 7)
                        {
                            dr["SCORE_3"] = CDataUtils2.GetDSDoubleValue(drS, "SCORE");
                            dr["DATE_3"] = CDataUtils2.GetDSDateTimeValue(drS, "COMPLETE_DATE");
                            dr["NAME_3"] = CDataUtils2.GetDSStringValue(drS, "NAME");
                            dr["INTERPRETATION_3"] = CDataUtils2.GetDSStringValue(drS, "INTERPRETATION");
                        }
                        if (j == 8)
                        {
                            dr["SCORE_2"] = CDataUtils2.GetDSDoubleValue(drS, "SCORE");
                            dr["DATE_2"] = CDataUtils2.GetDSDateTimeValue(drS, "COMPLETE_DATE");
                            dr["NAME_2"] = CDataUtils2.GetDSStringValue(drS, "NAME");
                            dr["INTERPRETATION_2"] = CDataUtils2.GetDSStringValue(drS, "INTERPRETATION");
                        }
                        if (j == 9)
                        {
                            dr["SCORE_1"] = CDataUtils2.GetDSDoubleValue(drS, "SCORE");
                            dr["DATE_1"] = CDataUtils2.GetDSDateTimeValue(drS, "COMPLETE_DATE");
                            dr["NAME_1"] = CDataUtils2.GetDSStringValue(drS, "NAME");
                            dr["INTERPRETATION_1"] = CDataUtils2.GetDSStringValue(drS, "INTERPRETATION");
                        }

                        j++;
                    }
                }
                dsScoreBase.AcceptChanges();
            }
        }

        //clear the grid
        storScores.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //load the gridpanel store
        if (!CDataUtils2.IsEmpty(dsScoreBase))
        {
            CDataConverter cdc = new CDataConverter();
            storScores.SetDataFromJson(cdc.GetJsonDSString(dsScoreBase));
        }
        
    }

    /// <summary>
    /// US:7498 Load the population with all patients for the site the user is logged into
    /// </summary>
    protected void LoadSitePatients()
    {
        //get the dataset
        CReportsPat rep = new CReportsPat();
        DataSet dsPop = rep.GetPatPopulationDS(Master);
        //
        //load the gridpanel store
        if (!CDataUtils2.IsEmpty(dsPop))
        {
            CDataConverter cdc = new CDataConverter();
            storPopulation.SetDataFromJson(cdc.GetJsonDSString(dsPop));
        }
    }

    /// <summary>
    /// page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        BaseMstr = Master;
        ucTrendGraph.BaseMstr = BaseMstr;

        //user must have the provider key to access this page
        CMDWSOps ops = new CMDWSOps(Master.GetDataObject());
        CStatus s = ops.HasSecurityKey(CDataUtils2.ToLong(Master.DUZ), "PROVIDER");
        
        if (s.StatusCode == k_STATUS_CODE.Failed)
        {
            Master.LogOff();
            return;
        }

        if (!IsPostBack)
        {
            //this page closes the patient
            Master.ClosePatient();

            //defult the date range
            dfFromDate.SelectedDate = DateTime.Today.AddDays(-180);
            dfToDate.SelectedDate = DateTime.Today;

            //load the sites full patient list
            LoadSitePatients();

            //init the trend tree
            //clear the root
            if (tpnlTrend.Root != null)
            {
                if (tpnlTrend.Root.Count > 0)
                {
                    tpnlTrend.Root.Clear();
                }
            }
            //add a new root
            Ext.Net.Node ndRoot;
            ndRoot = new Node() { Text = "" };
            ndRoot.Expanded = true;
            ndRoot.EmptyChildren = true;
            tpnlTrend.Root.Add(ndRoot);

            //disable trend
            btnMeasureTrend.Disable();
            btnShowNote.Disable();
        }

        //New gpScores GidPanle ToolTip Method 
        ToolTip toolTip = new ToolTip
        {
            ID = gpScores.ID + "_ToolTip",

            Target = gpScores.ClientID,

            Delegate = ".x-grid-cell",
            Closable = true,
            AutoHide = false,
            Draggable = true,
            AutoFocus = true,
            MouseOffset = new int[] { -9, -9 }
        };

        toolTip.Listeners.BeforeShow.Handler = "return onBeforeShow(#{" + toolTip.ID + "}, #{" + gpScores.ID + "});";
        toolTip.Listeners.Show.Handler = "onShow(#{" + toolTip.ID + "}, #{" + gpScores.ID + "});";
        gpScores.ToolTips.Add(toolTip);
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:7493 US:7495 US:7496 US:7494 US:7492 On patient select, load the report data
    /// </summary>
    public void OnPatSel(string strJSON)
    {
        btnShowNote.Disable();

        string strJ = strJSON;
        if (strJ.Length > 2)
        {
            if (strJ.Substring(0, 1) == "[")
            {
                strJ = strJ.Substring(1);
            }

            if (strJ.Substring(strJ.Length - 1, 1) == "]")
            {
                strJ = strJ.Substring(0, strJ.Length - 1);
            }
        }

        string strPatID = CDataUtils2.GetJsonRecordValue("PATIENT_ID", strJ);

        if (dfFromDate.SelectedDate.Year == 1)
        {
            return;
        }

        if (dfToDate.SelectedDate.Year == 1)
        {
            return;
        }

        //load the patients last 10 scores
        LoadScores(strPatID, dfFromDate.SelectedDate, dfToDate.SelectedDate);

        //load the trend tree
        LoadTrend(strPatID, dfFromDate.SelectedDate, dfToDate.SelectedDate);

        //load the patients notes
        LoadNotes(strPatID, dfFromDate.SelectedDate, dfToDate.SelectedDate);

        //disable trend
        btnMeasureTrend.Disable();

    }
       
}